﻿
<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="cu-codigoopcion.ascx.vb" Inherits="Web.cu_codigoopcion" %>

<asp:UpdatePanel class="station-table-holder codigoopcion" runat="server" Id="UpdatePanelCodigoOpcion" UpdateMode="Conditional" ChildrenAsTriggers="true">
<ContentTemplate>

<!-- Update progress -->
<asp:UpdateProgress ID="UpdateProgressCodigoOpcion" runat="server" AssociatedUpdatePanelID="UpdatePanelCodigoOpcion" DisplayAfter="100">
    <ProgressTemplate>
        <asp:Image ID="img_ajax_loading_MenuStation" runat="server" ImageUrl="~/images/ajax-loading.gif" CssClass="ajax_loading_centered"  />
    </ProgressTemplate>
</asp:UpdateProgress>

<div class="add-panel panel-blue text-left">
	<p><%= Translator.Translate("TRACE_OPERATION_CURRENT_OPERATION")%><strong><asp:Label ID="lblOperacionActual" runat="server" Text="CO00001" /></strong><span ID="lblModoVista" runat="server" style="float:right;"/></p>
</div>
<div class="station-details-tabs">
	<div id="divBloqueOperacion" class="tabs-inner js-table-holder" runat="server">
		<div class="js-height-block">
			<div class="details-tabset">
				<div class="buttons-holder item-ajax-tabset">
					<div id="divDetalleOperacion" class="button-box slide active" runat="server">
                        <asp:LinkButton ID="btnDetalleOperacion" runat="server" class="btn tab-btn"><span><%= Translator.Translate("TRACE_OPERATION_OPERATION_DETAIL")%></span></asp:LinkButton>
					</div>
					<div id="divDetalleTarea" class="button-box slide" runat="server">
                        <asp:LinkButton ID="btnDetalletarea" runat="server" class="btn tab-btn"><span><%= Translator.Translate("TRACE_OPERATION_DETAIL_TASK")%></span></asp:LinkButton>
					</div>
					<div id="divRequisitosPrevios" class="button-box slide" runat="server">
                        <asp:LinkButton ID="btnRequisitosPrevios" runat="server" class="btn tab-btn"></asp:LinkButton>
					</div>
					<div id="divRecursosAyuda" class="button-box slide" runat="server">
                        <asp:LinkButton ID="btnRecursosAyuda" runat="server" class="btn tab-btn"></asp:LinkButton>
					</div>
				</div>
				<div class="single-button">
                    <asp:LinkButton ID="btnVolver" CssClass="btn" runat="server"><%= Translator.Translate("TRACE_OPERATION_RETURN")%></asp:LinkButton>
				</div>
			</div>
			<div class="details-content">
				<div class="jcf-scrollable content-block">

                    <!-- Panel de detalle de una operación -->
                    <asp:Panel ID="panelDetalleOperacion" CssClass="detail-item-overview" runat="server" Visible="true">
                        <asp:Repeater ID="repeater_info_operacion" runat="server">
                            <ItemTemplate>
	                        <div class="item-information-block">
		                        <div class="grid-view">
			                        <div class="item-row">
				                        <div class="grid-item">
					                        <dl class="bordered halfheight">
						                        <dt><%= Translator.Translate("TRACE_OPERATION_INFO_TITLE")%></dt>
						                        <dd><%# Eval("Title")%></dd>
					                        </dl>
                                            <dl class="bordered quarterheight">
						                        <dt><%= Translator.Translate("TRACE_OPERATION_INFO_REQUIRED_SUPPORT")%></dt>
						                        <dd><%# Eval("RequiredSupport")%></dd>
					                        </dl>
                                            <dl>
						                        <dt><%= Translator.Translate("TRACE_OPERATION_INFO_STATE")%></dt>
						                        <dd><%# Eval("State")%></dd>
					                        </dl>
				                        </div>
				                        <div class="grid-item center-item">
					                        <div class="bordered-visual">
						                        <a href='<%# Eval("OptionImage")%>' class="visual-box image-lightbox">
                                                    <img src='<%# Eval("OptionImage")%>' alt="image description" runat="server" enableviewstate="true" />
						                        </a>
					                        </div>
				                        </div>
			                        </div>
		                        </div>
	                        </div>
                            </ItemTemplate>        
                            </asp:Repeater>                        
	                    <div class="item-information-table">
		                        <div class="information-title">
			                        <div class="title-text">
				                        <p><%= Translator.Translate("TRACE_OPERATION_GRIDVIEW_TASKS_HEADER")%></p>
			                        </div>
			                        <div class="title-number">
				                        <strong><asp:Label ID="lblNumTareasOperacion" runat="server" Text="2" /></strong>
			                        </div>
		                        </div>
		                        <div class="information-table">
                                    <asp:GridView ID="GridViewTareas" CssClass="result-table default-table" SkinId ="GridviewSkinLlistatV2" DataKeyNames ="CODEOPTION" runat="server" UseAccessibleHeader="false" PageSize="20"> 
				                    <Columns>
                                    <asp:TemplateField HeaderText ="Código" ItemStyle-CssClass="" HeaderStyle-CssClass="thead">
				                        <ItemTemplate>
                                            <asp:LinkButton ID="lnkOpcion" CssClass="link-underline absolute-lightbox" runat="server"  CommandName="CODEOPTION" CommandArgument='<%#Eval("CodeOption")%>'><%#Eval("CodeOption")%></asp:LinkButton>
				                        </ItemTemplate>
			                        </asp:TemplateField>
                                    <asp:TemplateField HeaderText ="Título" ItemStyle-CssClass="" HeaderStyle-CssClass="thead">
				                        <ItemTemplate>
					                    <asp:Label CssClass = "CampDades"  ID="lblrowFieldGridTitulo" runat="server" ToolTip='<%# Bind("title") %>' Text='<%# Bind("title") %>'></asp:Label>
				                        </ItemTemplate>
			                        </asp:TemplateField>
                                    <asp:TemplateField HeaderText ="Soporte" ItemStyle-CssClass="" HeaderStyle-CssClass="thead">
				                        <ItemTemplate>
					                    <asp:Label CssClass = "CampDades"  ID="lblrowFieldGridSoporte" runat="server" ToolTip='<%# Bind("RequiredSupport")%>' Text='<%# Bind("RequiredSupport") %>'></asp:Label>
				                        </ItemTemplate>
			                        </asp:TemplateField>
                                    <asp:TemplateField HeaderText ="Estado" ItemStyle-CssClass="" HeaderStyle-CssClass="thead">
				                        <ItemTemplate>
					                    <asp:Label CssClass = "CampDades"  ID="lblrowFieldGridEstado" runat="server" ToolTip='<%# Bind("State") %>' Text='<%# Bind("State") %>'></asp:Label>
				                        </ItemTemplate>
			                        </asp:TemplateField>
                                    <asp:ButtonField Text="DobleClick" CommandName="DobleClick" Visible="false" />
                                    </Columns>
                                    </asp:GridView>
                                    <asp:HiddenField ID="hdnGridViewLstOpciones_SelectedIndexClient" runat="server" Value="-1" />    
		                        </div>
	                        </div>
                    </asp:Panel>
                            
                    <!-- Vista de detalle de la tarea -->
                    <asp:Panel ID="panelDetalleTarea" CssClass="detail-item-overview" runat="server" Visible="false">
	                    <div class="add-panel panel-blue text-left">
		                    <p><%= Translator.Translate("TRACE_TASK_INFO_HEADER")%></p>
	                    </div>
                        <asp:Repeater ID="repeater_info_tarea" runat="server">
                        <ItemTemplate>

	                    <div class="item-information-block">
		                    <div class="grid-view">
			                    <div class="item-row">
				                    <div class="grid-item">
                                        <dl class="bordered quarterheight">
				                            <dt><%= Translator.Translate("TRACE_TASK_INFO_TITLE")%></dt>
				                            <dd><%# Eval("Title")%></dd><br />
                                            <dt><%= Translator.Translate("TRACE_TASK_INFO_TYPE")%></dt>
				                            <dd><%# Eval("TaskType")%></dd>
			                            </dl>
					                    <dl class="dl-horizontal">
                                            <div class="grid-item">
                                                
                                                <div class="bordered-visual alignleft" style="clear:both; float:left;" runat="server" visible='<%# If(Trim(CStr(Eval("ToolImage"))) = String.Empty, "false", "true")%>'>
						                            <a href='<%# Eval("ToolImage")%>' class="visual-box image-lightbox">
                                                        <img src='<%# Eval("ToolImage")%>' width="21" height="104" alt="image description" runat="server" enableviewstate="true" />
						                            </a>
					                            </div>
                                                <div style="padding-bottom:10px; display:table;">
                                                    <dt><%= Translator.Translate("TRACE_TASK_INFO_REQUIRED_TOOL")%></dt><br />
						                            <dd><%# Eval("RequiredTool")%></dd>
                                                </div>
                                            </div>
                                            <div class="grid-item">
                                                <div style="padding-bottom:10px; display:table;">
                                                    <dt><%= Translator.Translate("TRACE_TASK_INFO_REQUIRED_CARTRIDGE")%></dt><br />
                                                    <dd><%# Eval("RequiredCartridge")%></dd>
                                                </div>
                                                <div class="bordered-visual " style="clear:both;" runat="server" visible='<%# If(Trim(CStr(Eval("CartridgeImage"))) = String.Empty, "false", "true")%>'>
						                            <a href='<%# Eval("CartridgeImage")%>' class="visual-box image-lightbox">
                                                        <img src='<%# Eval("CartridgeImage")%>' width="118" height="77" alt="image description" runat="server" enableviewstate="true" />
						                            </a>
                                                </div>
                                            </div>
					                    </dl>
				                    </div>
                                    <div class="grid-item center-item">
                                        <dl class="bordered" style="text-align:left;">
                                            <dt><%= Translator.Translate("TRACE_TASK_INFO_REQUIRED_SUPPORT")%></dt>
                                            <dd><%# Eval("RequiredSupport")%></dd>
                                        </dl>   
					                    <div class="bordered-visual">
						                    <a href='<%# Eval("OptionImage")%>' class="visual-box image-lightbox">
                                                <img src='<%# Eval("OptionImage")%>' alt="image description" runat="server" enableviewstate="true" />
						                    </a>
					                    </div>
				                    </div>
			                    </div>
		                    </div>
	                    </div>
                        
                        </ItemTemplate>
                        </asp:Repeater>
                        <!-- Lista de componentes, requisitos y recursos de ayuda -->
                        <ajaxToolkit:Accordion ID="AccordionItemsTarea" runat="server" CssClass="open-close-nojs" HeaderCssClass="open-close-item " HeaderSelectedCssClass="open-close-item no-border-bottom active" ContentCssClass="open-close-item slide" RequireOpenedPane="false" Visible="true" SelectedIndex="0" SuppressHeaderPostbacks="true">
		                <Panes>
                            <ajaxToolkit:AccordionPane ID="AccordionComponentesTarea" runat="server">
                            <Header><asp:LinkButton ID="btnComponentesTarea" CssClass="opener opener-blue" runat="server">Componentes <strong class="count">2</strong></asp:LinkButton></Header>
                            <Content>
			                <div class="slide">
				                <div class="components-block">
                                    <asp:Repeater ID="repeater_componentes" runat="server">
                                    <ItemTemplate>
					                <div class="component-item">
						                <div class="item-name">
							                <dl class="dl-horizontal">
								                <dt><%= Translator.Translate("TRACE_TASK_INFO_COMPONENTS_REF")%></dt>
								                <dd><%# Eval("Reference")%></dd>
							                </dl>
						                </div>
						                <div class="item-visual">
							                <div class="bordered-visual">
								                <a href='<%# Eval("Image")%>' class="visual-box image-lightbox">
                                                    <img src='<%# Eval("Image")%>' width="54" height="39" alt="image description" runat="server" enableviewstate="true" />
								                </a>
							                </div>
						                </div>
					                </div>
                                    </ItemTemplate>
                                    </asp:Repeater>                                                                                        
				                </div>
			                </div>
                            </Content>
		                    </ajaxToolkit:AccordionPane>

                            <ajaxToolkit:AccordionPane ID="AccordionRequisitosTarea" runat="server">
                            <Header><asp:LinkButton ID="btnRequisitosPreviosTarea" CssClass="opener opener-blue" runat="server">Requisitos previos <strong class="count">1/4</strong></asp:LinkButton></Header>
                            <Content>
			                <div class="slide">
				                <div class="information-table requirements-table">
					                <table class="result-table default-table">

                                        <asp:Repeater ID="repeater_requisitos_previos" runat="server">
                                        <HeaderTemplate>
						                    <thead>
							                    <tr>
								                    <td class="thead"><%= Translator.Translate("TRACE_TASK_INFO_REQUIREMENTS_TYPE")%></td>
								                    <td class="thead"><%= Translator.Translate("TRACE_TASK_INFO_REQUIREMENTS_TITLE")%></td>
								                    <td class="thead text-center"><%= Translator.Translate("TRACE_TASK_INFO_REQUIREMENTS_REALIZED")%></td>
                                                    <td class="thead text-center"><%= Translator.Translate("TRACE_TASK_INFO_REQUIREMENTS_DATE")%></td>
							                    </tr>
						                    </thead>
						                    <tbody>
                                        </HeaderTemplate>
                                        <ItemTemplate>
							            <tr>
								            <td><%# Eval("RequirementType")%></td>
								            <td><%# Eval("Title")%></td>
								            <td class="text-center"><i class='<%# Eval("ClassRealized")%>'></i></td>
                                            <td class="text-center"><%# If(Trim(Eval("LastRunDate").ToString()) = String.Empty, Translator.Translate("TRACE_TASK_INFO_REQUIREMENT_UNREALIZED"), Eval("LastRunDate").ToString())%></td>
							            </tr>
                                        </ItemTemplate>
                                        <FooterTemplate>
                                            </tbody>
                                        </FooterTemplate>
						                </asp:Repeater>

					                </table>
				                </div>
			                </div>
                            </Content>
                        </ajaxToolkit:AccordionPane>

                            <ajaxToolkit:AccordionPane ID="AccordionRecursosTarea" runat="server">
                                <Header><asp:LinkButton ID="btnRecursosAyudaTarea" CssClass="opener opener-blue" runat="server">Recursos de ayuda <strong class="count">3</strong></asp:LinkButton></Header>
                                <Content>
			                    <div class="slide">
				                    <div class="information-table requirements-table">
					                    <table class="result-table default-table">

                                            <asp:Repeater ID="repeater_recursos_ayuda" runat="server">
                                            <HeaderTemplate>
						                    <thead>
							                    <tr>
								                    <td class="thead"><%= Translator.Translate("TRACE_TASK_INFO_HELP_RESOURCES_TYPE")%></td>
								                    <td class="thead"><%= Translator.Translate("TRACE_TASK_INFO_HELP_RESOURCES_TITLE")%></td>
							                    </tr>
						                    </thead>
						                    <tbody>
                                            </HeaderTemplate>
                                            <ItemTemplate>
							                    <tr>
								                    <td><%# Eval("ResourceType")%></td>
								                    <td><%# Eval("Title")%></td>
							                    </tr>
                                            </ItemTemplate>
                                            <FooterTemplate>
						                    </tbody>
                                            </FooterTemplate>    
                                            </asp:Repeater>

					                    </table>
				                    </div>
			                    </div>
                                </Content>
                            </ajaxToolkit:AccordionPane>
                        </Panes>                                                    
                        </ajaxToolkit:Accordion>
                    </asp:Panel>

                    <!-- Vista de los recursos de ayuda -->
                    <asp:Panel ID="panelRequisitosTarea" CssClass="detail-item-overview" runat="server" Visible="false">
                        <div class="slideshow components-carousel">
		                    <div class="slideset">
                                 <asp:Repeater ID="repeater_requisitos_previos2" runat="server">
                                 <ItemTemplate>
			                        <div class="slide">
				                        <div class="add-panel slide-title panel-blue panel-big">
					                        <div class="title">
						                        <p><%# Eval("Title")%></p>
					                        </div>
					                        <div class="slide-controls">
						                        <div class="slide-count">
                                                    <span class="current-num"><%# Eval("NumActual")%></span>/<span class="total-num"><%# Eval("NumTotal")%></span></div>
						                        <div class="slide-state">
							                        <i class='<%# Eval("ClassRealized")%>'></i>
						                        </div>
					                        </div>
					                        <a href="#" class="btn-next"></a>
					                        <a href="#" class="btn-prev"></a>
				                        </div>
				                        <div class="slide-content">
					                        <div class="slide-content-inner">
						                        <div class="component-title">
							                        <div class="checkbox" runat="server" visible='<%# If(Trim(CStr(Eval("IdRequirementType"))) = LibTrace.Constants.ID_TIPOREQUISITO_ESCANEO Or Trim(Me.hdnOrigen.Value) <> "ESTACION", "false", "true")%>'>
								                        <label for="radio1">
                                                            <asp:CheckBox ID="chkRealizado" AutoPostBack="true" OnCheckedChanged="checkbox_requisito_realizado" runat="server" Enabled='<%# If(Eval("Realized") = false, "true", "false")%>' Checked='<%# If(Eval("Realized") = true, "true", "false")%>' />
									                        <%= Translator.Translate("TRACE_TASK_INFO_REQUIREMENTS_REALIZED")%>
								                        </label>
							                        </div>
							                        <div class="title">
								                        <dl class="dl-horizontal">
									                        <dt><%= Translator.Translate("TRACE_TASK_INFO_REQUIREMENTS_TYPE")%>: </dt>
									                        <dd><%# Eval("RequirementType")%></dd>
                                                            <dt><%= Translator.Translate("TRACE_TASK_INFO_REQUIREMENTS_DATE")%>: </dt>
									                        <dd><%# If(Trim(Eval("LastRunDate").ToString()) = String.Empty, Translator.Translate("TRACE_TASK_INFO_REQUIREMENT_UNREALIZED"), Eval("LastRunDate").ToString())%></dd>
								                        </dl>
							                        </div>
						                        </div>
						                        <div class="component-visual" runat="server" visible='<%# If(Trim(CStr(Eval("Image"))) = String.Empty, "false", "true")%>'>
							                        <div class="bordered-visual">
								                        <a href='<%# Eval("Image")%>' class="visual-box image-lightbox">
                                                            <img src='<%# Eval("Image")%>' alt="image description" runat="server" enableviewstate="true" />
								                        </a>
							                        </div>
						                        </div>
					                        </div>
				                        </div>
			                        </div>
                                    <!-- Controles ocultos-->
                                    <asp:HiddenField ID="hdnIdRequirement" runat="server" value='<%# Eval("Id")%>' />
                                </ItemTemplate>
                                </asp:Repeater>
		                    </div>
	                    </div>
                     </asp:Panel>

                    <!-- Vista de los recursos de ayuda -->
                    <asp:Panel ID="panelRecursosAyuda" CssClass="detail-item-overview" runat="server" Visible="false">
                        <div class="slideshow components-carousel">
                                <div class="slideset">
                                   <asp:Repeater ID="repeater_recursos_ayuda2" runat="server">
                                    <ItemTemplate>
			                        <div class="slide">
				                        <div class="add-panel slide-title panel-blue panel-big">
					                        <div class="title">
						                        <p><%# Eval("Title")%></p>
					                        </div>
					                        <div class="slide-controls">
						                        <div class="slide-count">
							                        <span class="current-num"><%# Eval("NumActual")%></span>/<span class="total-num"><%# Eval("NumTotal")%></span>
						                        </div>
					                        </div>
					                        <a href="#" class="btn-next"></a>
					                        <a href="#" class="btn-prev"></a>
				                        </div>
				                        <div class="slide-content" runat="server" visible='<%# If(Trim(CStr(Eval("ResourceType"))) <> "VIDEO", "true", "false")%>'>
					                        <div class="slide-content-inner">
                                                <div class="component-title">
							                        <div class="title">
								                        <p><%# Eval("Description")%></p>
							                        </div>
						                        </div>
                                                <div class="component-visual" runat="server" visible='<%# If(Trim(CStr(Eval("File"))) = String.Empty or Trim(CStr(Eval("ResourceType"))) <> "IMAGEN", "false", "true")%>'>
							                        <div class="bordered-visual">
								                        <a href='<%# Eval("File")%>' class="visual-box image-lightbox">
                                                            <img src='<%# Eval("File")%>' alt="image description" runat="server" enableviewstate="true" />
								                        </a>
							                        </div>
						                        </div>
                                            
					                        </div>
                                        </div>
                                        <video controls runat="server" visible='<%# If(Trim(CStr(Eval("File"))) = String.Empty Or Trim(CStr(Eval("ResourceType"))) <> "VIDEO", "false", "true")%>'>
                                        <source src='<%# Eval("File")%>' type="video/mp4" runat="server">
                                            I'm sorry; your browser doesn't support HTML5 video.
                                        </video>
                                    </div>                                                                            
			                        </ItemTemplate>
                                    </asp:Repeater>
                                </div>
                            </div>
                    </asp:Panel>

				</div>
			</div>
		</div>
	</div>
</div>

<!-- controles ocultos-->
<asp:HiddenField ID="hdnCodigoOpcion" runat="server" />
<asp:HiddenField ID="hdnHeaderHeight" runat="server" Value="210" />
<asp:HiddenField ID="hdnOrigen" runat="server" />
<asp:HiddenField ID="hdnPuerto" runat="server" />

</ContentTemplate>
</asp:UpdatePanel>

<ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderCodigoOpcion" TargetControlID="UpdatePanelCodigoOpcion" BehaviorID="animation" runat="server">    
<Animations>    
    <OnUpdated>
        <Sequence>
            <ScriptAction Script="initRefreshFunctions($('div.codigoopcion'));" />
        </Sequence>
    </OnUpdated>
</Animations>
</ajaxToolkit:UpdatePanelAnimationExtender>









